#ifndef __DM_CIP_H__
#define __DM_CIP_H__

/**
 *
 * \file        cip.h
 *
 * \brief       Header file for Cresnet Over IP
 *
 * \author      Pete McCormick
 *
 * \date        5/25/2008
 *
 * \note        This file should work for DM and IDOCV
 *
 * \note        Some stuff copied from udpserv.h and masterlist.h
 */

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_DNS_NAME_LENGTH             0x100   // max length is 255 + 1 byte for length

#define DM_MAX_CIP_MSG_LEN                 0x106   // Max Cresnet msg size + CIP header

#define MAX_SITE_NAME 256
////////////////////////////////////////////////////////////////////////////////

typedef struct MasterListEntry_s
{
    unsigned short  CIP_ID;
    unsigned short  DeviceID;
    unsigned long   IP_Address;
    char            SiteName[MAX_SITE_NAME];
    unsigned char   InTransNumber;
    unsigned char   OutTransNumber;
    //unsigned char   TransmitState;
    short int       LinkStatus;
    //unsigned char   NumOutputMsgsQueued;
    //NU_SEMAPHORE    *NodeSemaphore;
    //UINT32 OutputPipe;
    //unsigned char   *ActiveOutputPacket;
    //unsigned short  ActivePacketLength;
    unsigned short  Flags;
    //PEM - we don't need these
    //unsigned long   analog_flags[(MAX_NUM_ANALOGS + 31) / 32];
    //unsigned char   mouse_flags[5];
    unsigned long   handle;
    unsigned char   m_bUpdateRequestSent;
    //unsigned char   wasted_space[2];
    int socket; // added this here for convenience
    struct MasterListEntry_s  *Next;
} MASTER_LIST_ENTRY, *pMASTER_LIST_ENTRY;

typedef struct
{
    unsigned char PacketType;
    unsigned char TransNumber;
    unsigned short Flags;
    unsigned short DataLength;
} CIP_HEADER_INFO, *pCIP_HEADER_INFO;

typedef struct
{
    CIP_HEADER_INFO Header;
    unsigned char   Data[DM_MAX_CIP_MSG_LEN - sizeof(CIP_HEADER_INFO)];
} *pCIP_PACKET, CIP_PACKET;

////////////////////////////////////////////////////////////////////////////////

extern INT32 CipSlaveSendPacket(MASTER_LIST_ENTRY * DestPtr, UINT8 *Packet, UINT32 PacketLength);
extern MASTER_LIST_ENTRY * MasterListLockInst(UINT32 inst);
extern void MasterListUnlockInst(UINT32 inst);
MASTER_LIST_ENTRY * FindMasterByName(char *);
MASTER_LIST_ENTRY * FindMasterByIpString(char * ipString);
extern UINT32 CIPMaxMasters(void);
extern void MasterListWipe(void);
extern int RemoveEntryFromMasterList(unsigned short CIP_ID, unsigned long IP_Address,
                                char *SiteName);
extern MASTER_LIST_ENTRY* AddEntryToMasterList(unsigned short CIP_ID, unsigned long IP_Address,
                                        char *SiteName, unsigned short  DeviceID, unsigned short port, unsigned short NodeFlags);
extern void MasterListSaveParams(void);

extern void CIPOnlineEvent(MASTER_LIST_ENTRY * pMaster);
extern void CIPOfflineEvent(MASTER_LIST_ENTRY * pMaster);
extern void MyCipOnlineEvent(void);
extern void MyCipOfflineEvent(void);

void SaveMasterListParams(MASTER_LIST_ENTRY *MasterList);
#ifdef PROAMP_7X400
// Option to read local IP instead of master list.
extern UINT8 CanReadLoaclListIp (void);
extern MASTER_LIST_ENTRY * GetLocalListIp (void);
#endif // PROAMP_7X400
MASTER_LIST_ENTRY * GetMasterList(void);
INT32 SetCIPPort(UINT32 ignore, char * cmd);
INT32 ShowIpTable(UINT32 ignore, char * cmd);
UINT8 IsIpTableEmpty();
UINT16 GetIpId(void);
extern UINT32 CIPGetPort(void);
UINT8 IsCIPQueueFull(UINT8 bStream);
void DefaultIPTable(void);
////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif


